/************************************************************************
 * NAME:	fileio.h
 *
 * DESCR:	file io includables
 *
 *
 * NOTES:	
 ************************************************************************/

struct cocofs;

struct coco_file {
    struct cocofs *cocofs;	/* pointer back to the file system	*/
    int		 inuse;		/* TRUE if in use, FALSE otherwise	*/
    coco_inode	 inode;		/* the inode of the open file		*/
    char	*buffer;	/* stores a gran (alloc'd during init)	*/
    int		 bufsize;	/* size (in bytes) of buffer		*/
    int		 firstgran;	/* first gran where this file is	*/
    int		 curgran;	/* current gran in buffer (0 if none)	*/
    int		 cursize;	/* current size of data in buffer	*/
    int		 curgran_no;	/* which ordinal gran of file is this	*/
    int		 lastsectors;	/* number of sectors in last gran	*/
    int		 lastbytes;	/* number of bytes in last sector	*/
    int		 cursor;	/* byte position within buffer		*/
                                /* points to NEXT byte to be consumed	*/
    int		 writemode;	/* TRUE if writing			*/
};

extern int coco_file_flush(struct coco_file *);
extern struct coco_file *coco_file_open(struct cocofs *, char *);
extern struct coco_file *coco_file_new(struct cocofs *, char *, int, int);
extern void coco_file_close(struct coco_file *);
